<?php
/*
 لا يمكنك تغيير أو تعديل أي جزء من هذا التعليق أو الاعتمادات
 من مطوري الدعم من هذا الشيفرة البرمجية أو أي شيفرة برمجية داعمة أخرى
 التي تعتبر موادًا محمية بحقوق التأليف والنشر (c) للتعليق الأصلي أو أصحاب الاعتماد.

 يتم توزيع هذا البرنامج على أمل أن يكون مفيدًا،
 ولكن بدون أي ضمان؛ بدون حتى الضمان الضمني للتسويق أو ملاءمة لغرض معين.
*/
/**
 *  Xoops Language
 *
 * @copyright       (c) 2000-2016 XOOPS Project (www.xoops.org)
 * @license             GNU GPL 2 (https://www.gnu.org/licenses/gpl-2.0.html)
 * @package             kernel
 * @subpackage          Xoops Mailer Local Language
 * @since               2.3.0
 * @author              Taiwen Jiang <phppp@users.sourceforge.net>
 */
defined('XOOPS_ROOT_PATH') || exit('Restricted access');
/**
 * Localize the mail functions
 *
 * The English localization is solely for demonstration
 */
// Do not change the class name
class XoopsMailerLocal extends XoopsMailer
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
        // من المفترض أنه لا حاجة لتغيير ترميز الحروف
        $this->charSet = strtolower(_CHARSET);
        // يجب عليك تحديد قيمة كود اللغة حتى يتم العثور على الملف: XOOPS_ROOT_PAT/class/mail/phpmailer/language/lang-["your-language-code"].php
        $this->multimailer->setLanguage('ar');
    }

    /**
     * Multibyte languages are encouraged to make their proper method for encoding FromName
     *
     * @param $text
     *
     * @return mixed
     */
    public function encodeFromName($text)
    {
        // قم بتنشيط السطر التالي إذا كان ذلك ضروريًا
        // $text = "=?{$this->charSet}?B?".base64_encode($text)."?=";
        return $text;
    }


    /**
     * Multibyte languages are encouraged to make their proper method for encoding Subject
     *
     * @param $text
     *
     * @return mixed
     */
    public function encodeSubject($text)
    {
        // قم بتنشيط السطر التالي إذا كان ذلك ضروريًا
        // $text = "=?{$this->charSet}?B?".base64_encode($text)."?=";
        return $text;
    }
}
