<?php
/*
 لا يمكنك تغيير أو تعديل أي جزء من هذا التعليق أو اعتبار أي جزء من هذا الشيفرة المصدرية أو أي شيفرة مصدرية داعمة
 تعتبر مواد محمية بحقوق الطبع والنشر (c) للمؤلف الأصلي للتعليق أو الشيفرة المصدرية الداعمة.

 يتم توزيع هذا البرنامج على أمل أن يكون مفيدًا،
 ولكن بدون أي ضمان؛ بدون حتى الضمان المتضمن أو القابل للتطبيق بموجب أي ضمان ضمني للتسويق أو اللياقة لغرض معين.
*/

/**
 * مفترق اللغة لـ XOOPS
 *
 * @copyright       (c) 2000-2016 مشروع XOOPS (www.xoops.org)
 * @license             GNU GPL 2 (https://www.gnu.org/licenses/gpl-2.0.html)
 * @package             kernel
 * @since               2.3.0
 * @author              Taiwen Jiang <phppp@users.sourceforge.net>
 * @todo                يجب التعامل معها بواسطة i18n/l10n
 *  المترجم: arxoops.com
 */
defined('XOOPS_ROOT_PATH') || exit('تم الوصول بشكل مقيد');

setlocale(LC_ALL, 'en_US');

// !!هام!! أدخل '\' قبل أي حرف بين الأحرف المحفوظة: "a","A","B","c","d","D","e","F","g","G","h","H","i","I","j","l","L","m","M","n","O","r","s","S","t","T","U","w","W","Y","y","z","Z"
// أدخل '\' مزدوجة قبل 't','r','n'
define('_TODAY', "\T\o\d\a\y G:i");
define('_YESTERDAY', "\Y\\e\s\\t\\e\\r\d\a\y G:i");
define('_MONTHDAY', 'n/j G:i');
define('_YEARMONTHDAY', 'Y/n/j G:i');
define('_ELAPSE', '%s مضت');
define('_TIMEFORMAT_DESC', "تنسيقات صالحة: \"s\" - " . _SHORTDATESTRING . "; \"m\" - " . _MEDIUMDATESTRING . "; \"l\" - " . _DATESTRING . ';<br>' . "\"c\" أو \"custom\" - التنسيق المحدد وفقًا للفاصل الزمني حتى الحاضر؛; \"e\" - مضى؛; \"mysql\" - Y-m-d H:i:s;<br>" . "سلسلة محددة - راجع <a href=\"https://php.net/manual/en/function.date.php\" rel=\"external\">دليل PHP</a>.");

if (!class_exists('XoopsLocalAbstract')) {
    include_once XOOPS_ROOT_PATH . '/class/xoopslocal.php';
}

/**
 * لغة محلية في arxoops
 *
 * @package             kernel
 * @subpackage          Language
 *
 * @author              Taiwen Jiang <phppp@users.sourceforge.net>
 * @copyright       (c) 2000-2016 مشروع XOOPS (www.xoops.org)
 */
class XoopsLocal extends XoopsLocalAbstract
{
    /**
     * تنسيق الأرقام
     *
     * @param  unknown_type $number
     * @return mixed
     */
    public function number_format($number)
    {
        return number_format($number, 2, '.', ',');
    }

    /**
     * تنسيق العملة
     *
     * @param  string $format
     * @param  string $number
     * @return money  format
     */
    public function money_format($format, $number)
    {
        setlocale(LC_MONETARY, 'en_US');

        return money_format($format, $number);
    }
}
